	% Box 15.1
	clear all, close all, clc
	
	wcT = 0.05*pi;	wsT = 0.1*pi;	dc = 0.01;	ds = 0.001;
	[N0, Be, D, W] = HERRMANN_LP_FIR_ORDER([wcT wsT], [dc ds]);
	N0 = N0+5
	wT = linspace(0,pi,1000); 
	[h0, Err] = REMEZ_FIR(N0, Be, D, W, 'm'); 	
	H0 = freqz(h0,1,wT);
	subplot(3,1,1),	PLOT_MAG_Z_dB(wT, H0, pi, 80, 'H_0')
	M = 6;	;% < 2*pi/wsT = 6.67
	dcD = dc/2; dsD = sqrt(ds);
	[ND, Be, D, W] = HERRMANN_LP_FIR_ORDER([wcT wsT], [dcD dsD]);
	ND =75
	[hD, Err] = REMEZ_FIR(ND, Be, D, W, 'm');
	HD = freqz(hD,1,wT);
	subplot(3,1,2), PLOT_MAG_Z_dB(wT,HD, pi, 80, 'H_D| = |H_I')
	HI = HD;
	H = HI.*HD;
	subplot(3,1,3), PLOT_MAG_Z_dB(wT, H, pi, 80, 'H')
 	hD = [hD,0,0]; 						% Make length(hD)/M an integer
	P = reshape(hD, M, length(hD)/M)	% Polyphase components
	xlabel('{\it\omegaT} [rad]');		
	%	Amax= H_2_MAG((1+dc)/(1-dc))
	Amax= max(H_2_MAG(H(1:50)))-min(H_2_MAG(H(1:50)))
	Amin = max(H_2_MAG(H(101:end)))
	zoom on
	
	% PROBLEM  Aliasing
	figure(2)
	wT = linspace(0,pi,1000); 
	M = 6;	HI = freqz(hD, 1, wT);
	subplot('position', [0.1 0.4 0.88 0.5]);
	for k = 1:M-1
		D = -2*pi*k/M;
		H = HI.*freqz(hD,1, wT+D);
		PLOT_MAG_Z_dB(wT, H, pi, 80, '-')
		hold on
	end
